Scriptname FNIS_PCEA2QuestScript extends Quest 

bool[] Property isSelected Auto
bool[] Property isSelectedStart Auto
bool Property isStartOK Auto
int Property PCEA2crc Auto
Quest Property MQ101 Auto


int MaxGroup = 54

int CurrentAction				; 0: none 1: set 2: refresh
int QueuedAction				; same

Event OnInit()
	If !self.isRunning()		; if quest isn't started, despite being "start game enabled"
		self.Start()
		return
	endIf

	isStartOK = RequirementsAreMet()
	if !isStartOK
		return
	endif

	isSelected = new bool[10]
	isSelectedStart = new bool[10]
	PCEA2crc = FNIS_PCEA2.GetCRCvalue()
	
	string[] SelectionName = FNIS_PCEA2.GetSubDirList()
	int i
	while ( i < 10 ) && ( i <= SelectionName.Length )
 		if ( StringUtil.GetNthChar(SelectionName[i],1) == "_" )
			isSelected[i] = true
		endif
		i += 1
	endwhile
	
	RegisterForModEvent("PCEA2Task", "OnPCEA2Event")
	
	if MQ101.IsCompleted()							; set initial animations ONLY when Helgen quest is finished (avoid intro hickup)
		SetAAanimations(true)
	endif
	
	Debug.Trace("FNIS PCEA2 started.")
EndEvent

Event OnPCEA2Event(string eventName, string strArg, float numArg, Form sender)
;Debug.Trace("PCEA2 event received: " + strArg) 

;Debug.Trace("PCEA2 before setting - FNISaa_magidle: " + Game.GetPlayer().GetAnimationVariableInt("FNISaa_magidle"))
;Debug.Trace("PCEA2 before setting - FNISaa_magatk: " + Game.GetPlayer().GetAnimationVariableInt("FNISaa_magatk"))

	bool isRefresh
	int i
	int j

	if ( QueuedAction > 0 )
		return
	endif
	
	if ( strArg == "refresh" )
		if ( CurrentAction == 1 )
			QueuedAction = 2 
			return
		endif
		CurrentAction = 2
		SetAAanimations(true)			; execute refresh
	else								; "set"
		if ( CurrentAction == 2 )
			QueuedAction = 1 
			return
		endif
		CurrentAction == 1
		SetAAanimations(false)			; execute aa	
	endif
	
	if ( QueuedAction == 1 )
		CurrentAction = 1
		SetAAanimations(false)			; execute queued aa
	elseif ( QueuedAction == 2 )
		CurrentAction = 2
		SetAAanimations(true)			; execute queued refresh
	endif

	CurrentAction = 0
	QueuedAction = 0 

;Debug.Trace("PCEA2 AFTER setting - FNISaa_magidle: " + Game.GetPlayer().GetAnimationVariableInt("FNISaa_magidle"))
;Debug.Trace("PCEA2 AFTER setting - FNISaa_magatk: " + Game.GetPlayer().GetAnimationVariableInt("FNISaa_magatk"))
	
EndEvent

Function SetAAanimations(bool bRefresh)
Debug.trace("PCEA2 SetAA animations - refresh: " + bRefresh)
	int i
	int j
	bool[] isGroupIncluded
	bool[] isGroupChanged
	int[] MaxIndex
	int[] CurrentIndex
	isGroupIncluded = new bool[54]
	isGroupChanged = new bool[54]
	MaxIndex = new int[54]
	CurrentIndex = new int[54]

	string GroupList = FNIS_PCEA2.GetAnimGroupList()
	i = 0
	while ( i < 11 )
		if ( StringUtil.GetNthChar(GroupList,i*MaxGroup) != "X" )
			j = 0
			while ( j < MaxGroup )
				if ( StringUtil.GetNthChar(GroupList, i*MaxGroup+j) == 1 )
					if ( i == 10 )					;combination list
						isGroupIncluded[j] = true
					else
						MaxIndex[j] = MaxIndex[j] + 1
						if isSelected[i]
							CurrentIndex[j] = MaxIndex[j]
						endif
						if ( isSelected[i] != isSelectedStart[i] )
							isGroupChanged[j] = true
						endif
					endif
				endif
				j += 1
			endwhile
		endif
		i += 1
	endwhile
	
	int FNISpcea2ModID = FNIS_aa.GetAAModID("fp2", "FNIS PCEA2", true)
	int[] FNISpcea2Base = FNIS_aa.GetAllGroupBaseValues(FNISpcea2ModID, "FNIS PCEA2", true)
	actor player = Game.GetPlayer()
 
	i = 0
	bool boK
	bool isAnyGroupChanged
string sGroups = "mtidle   1hmidle  2hmidle  2hwidle  bowidle  cbowidle h2hidle  magidle  sneakidlestaffidlemt       mtx      mtturn   1hmmt    2hmmt    bowmt    magmt    magcastmtsneakmt  1hmatk   1hmatkpow1hmblock 1hmstag  2hmatk   2hmatkpow2hmblock 2hmstag  2hwatk   2hwatkpow2hwblock 2hwstag  bowatk   bowblock h2hatk   h2hatkpowh2hstag  magatk   1hmeqp   2hweqp   2hmeqp   axeeqp   boweqp   cboweqp  dageqp   h2heqp   maceqp   mageqp   stfeqp   shout    magcon   dw       jump     sprint   shield   "
	while ( i < MaxGroup )
;bool DUMMY = isGroupChanged[i] || ( bRefresh && ( MaxIndex[i] > 0 ) )
;Debug.Trace("FNIS PCEA2 SetAnimation bRefresh: " + bRefresh + " i: " + i + " isGroupChanged[i]: " + isGroupChanged[i] + " MaxIndex[i]: " + MaxIndex[i] + " RESULT: " + DUMMY)
		if isGroupChanged[i] || ( bRefresh && ( MaxIndex[i] > 0 ) ) 
			string s = StringUtil.Substring(sGroups, i*9, 9) + " "
			int pos = StringUtil.Find(s, " ")
			string sGroup = "_" + StringUtil.Substring(s, 0, pos)
			if ( CurrentIndex[i] == 0 )
				bOk = FNIS_aa.SetAnimGroup(player, sGroup, 0, 0, "FNIS PCEA2", true)
			else
				bOk = FNIS_aa.SetAnimGroup(player, sGroup, FNISpcea2Base[i], CurrentIndex[i] - 1, "FNIS PCEA2", true)
			endif
			isAnyGroupChanged = true
		endif
		i += 1		
	endWhile
	
	; send sync event to other mods (e.g. XPMSE)
	if isAnyGroupChanged
		SendModEvent("FNISaa_AnimVarsSet", "FNIS_PCEA2")
	endif
	
;Debug.Trace("PCEA2 SetAAanimations " + bRefresh + " DONE.")
endFunction

bool Function RequirementsAreMet()
	bool isGenerated = FNIS.isGenerated()
	string VersionToString = FNIS.VersionToString()
	bool isVersionOK = (FNIS.VersionCompare( 6, 0, 0 ) >= 0)
	bool isFNISesp = (Game.GetModByName("FNIS.esp") < 255)
	bool isFNIS_PCEA2esp = (Game.GetModByName("FNIS_PCEA2.esp") < 255)
	bool isSKSE = (SKSE.GetVersionRelease() > 0)
	if ! (isGenerated && isVersionOK && isSKSE && isFNISesp && isFNIS_PCEA2esp)
		string out = "FNIS PCEA2 stopped with ERROR(s):"
		if ! isVersionOK
			out = out + "\n- FNIS version " + VersionToString + " older than required" 
		endif
		if ! isGenerated
			out = out + "\n- Last FNIS generation failed" 
		endif
		if ! isFNIS_PCEA2esp
			out = out + "\n- FNIS_PCEA2.esp not activated" 
		endif
		if ! isFNISesp
			out = out + "\n- FNIS.esp not activated" 
		endif
		if ! isSKSE
			out = out + "\n- SKSE not started" 
		endif
		Debug.Messagebox(out)
		Debug.Trace(out)
		return false
	endif
	return true
EndFunction
		
